﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Activities;
using System.ServiceModel;

namespace BMSWFConsoleHost
{
    class Program
    {
        const string hostBaseAddress = "http://localhost:16050/ATDWFService";

        static void Main(string[] args)
        {  
            // Create service host.
            WorkflowServiceHost host = new WorkflowServiceHost(
                new BMSWFService.TestTransfer(),
                new Uri(hostBaseAddress));

            // Add service endpoints. 
            host.AddServiceEndpoint("IAdmissionTransferDischarge", new WSFederationHttpBinding("ServiceBinding"), "");
            host.AddServiceEndpoint("IAdmissionTransferDischarge", new BasicHttpBinding(), "unsec");

            // Open service host.
            host.Open();

            Console.WriteLine("Started");
            Console.ReadLine();
        }
    }
}
